# 时间序列图脚本 - 保存为time_series.gp
set terminal pngcairo enhanced font "Arial,12" size 800,600
set output 'pressure_time_series.png'

# 图表设置
set title 'Pressure vs Time at Different Probe Locations' font "Arial,14"
set xlabel 'Time (s)' font "Arial,12"
set ylabel 'Pressure (Pa)' font "Arial,12"
set grid
set key outside right top

# 设置科学计数法格式
set format x "%.2e"

# 绘制数据
plot './postProcessing/probes/0/p' using 1:2 title 'Probe 0 ' with linespoints pt 7 ps 1.5 lw 2, \
     './postProcessing/probes/0/p' using 1:3 title 'Probe 1 ' with linespoints pt 9 ps 1.5 lw 2, \
     './postProcessing/probes/0/p' using 1:4 title 'Probe 2 ' with linespoints pt 5 ps 1.5 lw 2, \
     './postProcessing/probes/0/p' using 1:5 title 'Probe 3 ' with linespoints pt 11 ps 1.5 lw 2, \
     './postProcessing/probes/0/p' using 1:6 title 'Probe 4 ' with linespoints pt 13 ps 1.5 lw 2

