/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     | Website:  https://openfoam.org
    \\  /    A nd           | Copyright (C) 2022-2023 OpenFOAM Foundation
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "buoyantBoussinesqSimpleFoam.H"
#include "fvmLaplacian.H"
#include "fvmDiv.H"

// * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * * //
void Foam::solvers::buoyantBoussinesqSimpleFoam::thermophysicalPredictor()
{
    volScalarField& alphat(alphat_);
    volScalarField& T(T_);

    alphat = momentumTransport->nut()/Prt_;
    alphat.correctBoundaryConditions();

    volScalarField alphaEff("alphaEff", momentumTransport->nu()/Pr_ + alphat);

    fvScalarMatrix TEqn
    (
        
        fvm::div(phi, T)
      - fvm::laplacian(alphaEff, T)
     ==
        fvModels().source(T)
    );

    TEqn.relax();
    fvConstraints().constrain(TEqn);
    TEqn.solve();
    fvConstraints().constrain(T);

    rhok_ = 1.0 - beta_*(T_ - TRef_);
}


// ************************************************************************* //
