    // Solve the momentum equation

    MRF.correctBoundaryVelocity(U);

    tmp<fvVectorMatrix> tUEqn
    (
         fvm::div(phi, U)
      + MRF.DDt(U)
      //+ turbulence->divDevReff(U)
      + turbulence->divDevSigma(U)
    ==
      fvModels.source(U)
      //fvOptions(U)
    );

    fvVectorMatrix& UEqn = tUEqn.ref();

    UEqn.relax();

    //fvOptions.constrain(UEqn);
    fvConstraints.constrain(UEqn);

    if (simple.momentumPredictor())
    {
        solve
        (
            UEqn
         ==
            fvc::reconstruct
            (
                (
                  - ghf*fvc::snGrad(rhok)
                  - fvc::snGrad(p_rgh)
                )*mesh.magSf()
            )
        );

        //fvOptions.correct(U);
        fvConstraints.constrain(U);
    }
