/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright (C) 1991-2009 OpenCFD Ltd.
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM; if not, write to the Free Software Foundation,
    Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

Application
    CreateTurbulenceFields

Description
    Creates a full set of turbulence fields.

    - Currently does not output nut and nuTilda

Source files:
    // createFields.H

\*---------------------------------------------------------------------------*/

#include "fvCFD.H"
#include "singlePhaseTransportModel.H"
#include "turbulenceModel.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

int main(int argc, char *argv[])
{
    timeSelector::addOptions();

    #include "setRootCase.H"
    #include "createTime.H"

    instantList timeDirs = timeSelector::select0(runTime, args);

    #include "createMesh.H"
    // #include "createFields.H"

    forAll(timeDirs, timeI)
    {
        runTime.setTime(timeDirs[timeI], timeI);

        Info<< "Time = " << runTime.timeName() << endl;

	   #include "createFields.H" // The only modification

        // Cache the turbulence fields

	volScalarField k
	(
	IOobject
	(
		"k",
 		runTime.timeName(),
 		mesh,IOobject::NO_READ,
 		IOobject::NO_WRITE
 	),
 	turbulence->k()
 	);

	volScalarField epsilon
	(
	IOobject
	(
		"epsilon",
 		runTime.timeName(),
 		mesh,IOobject::NO_READ,
 		IOobject::NO_WRITE
 	),
 	turbulence->epsilon()
 	);

	volSymmTensorField R
	(
	IOobject
	(
		"R",
 		runTime.timeName(),
 		mesh,IOobject::NO_READ,
 		IOobject::NO_WRITE
 	),
 	turbulence->R()
 	);

	volSymmTensorField Reff
	(
	IOobject
	(
		"Reff",
 		runTime.timeName(),
 		mesh,IOobject::NO_READ,
 		IOobject::NO_WRITE
 	),
 	turbulence->devReff()
 	);

        // Check availability of tubulence fields and write out

        if (!IOobject("k", runTime.timeName(), mesh).headerOk())
            k.write();
        else
            Info<< "\nTurbulence k field already exists" << endl;

        if (!IOobject("epsilon", runTime.timeName(), mesh).headerOk())
            epsilon.write();
        else
		Info<< "\nTurbulence epsilon field already exists" << endl;

        if (!IOobject("R", runTime.timeName(), mesh).headerOk())
        	R.write();
        else
        	Info<< "\nTurbulence R field already exists" << endl;
	if (!IOobject("Reff", runTime.timeName(), mesh).headerOk())
        	Reff.write();
        else
        	Info<< "\nTurbulence R effective field already exists" << endl;
    }

    Info<< "\nEnd\n" << endl;

    return 0;
}


// ************************************************************************* //

