    // Initialise fluid field pointer lists
PtrList<singlePhaseTransportModel> laminarTransportFluid(fluidRegions.size());//jiade
    PtrList<volVectorField> UFluid(fluidRegions.size());
    PtrList<surfaceScalarField> phiFluid(fluidRegions.size());
    PtrList<surfaceScalarField> phi_0Fluid(fluidRegions.size());
    PtrList<volScalarField> pFluid(fluidRegions.size());
    PtrList<volScalarField> TFluid(fluidRegions.size());
PtrList<incompressible::turbulenceModel> turbulenceFluid(fluidRegions.size());//jiade
  //PtrList<volScalarField> alphaFluid(fluidRegions.size());
    PtrList<volScalarField> alphatFluid(fluidRegions.size());//jiade
    //Initialise the MHD pointer lists
    
    PtrList<dimensionedScalar> nuFluid(fluidRegions.size());
    PtrList<dimensionedScalar> rhoFluid(fluidRegions.size());
    PtrList<dimensionedScalar> deltTFluid(fluidRegions.size());
    PtrList<dimensionedScalar> betaFluid(fluidRegions.size());
    PtrList<dimensionedVector> gFluid(fluidRegions.size());
    PtrList<dimensionedScalar> PrtFluid(fluidRegions.size());//jiade
    PtrList<dimensionedScalar> PrFluid(fluidRegions.size());//jiade
    PtrList<dimensionedScalar> T_0Fluid(fluidRegions.size());

    
    List<label> pRefCellFluid(fluidRegions.size(), 0);
    List<scalar> pRefValueFluid(fluidRegions.size(), 0.0);
    List<label> ElPotRefCellFluid(fluidRegions.size(), 0);
    List<scalar> ElPotRefValueFluid(fluidRegions.size(), 0.0);
    
    PtrList<volVectorField> LforceFluid(fluidRegions.size());
    PtrList<volVectorField> JecFluid(fluidRegions.size());
    PtrList<surfaceVectorField> JetfFluid(fluidRegions.size());
    PtrList<surfaceScalarField> JstfFluid(fluidRegions.size());
    PtrList<surfaceVectorField> JubefFluid(fluidRegions.size());
    PtrList<surfaceScalarField> JubsfFluid(fluidRegions.size());
    PtrList<surfaceScalarField> JsfFluid(fluidRegions.size());
    PtrList<surfaceVectorField> UfFluid(fluidRegions.size());
    PtrList<volVectorField> BFluid(fluidRegions.size());
    PtrList<surfaceVectorField> BfFluid(fluidRegions.size());
 // PtrList<volScalarField> sigmaMagFluid(fluidRegions.size());
    PtrList<volScalarField> sigmaFluid(fluidRegions.size());
    PtrList<volScalarField> ElPotFluid(fluidRegions.size());

    // Populate fluid field pointer lists
    forAll(fluidRegions, i)
    {
        Info<< "*** Reading fluid mesh thermophysical properties for region "
            << fluidRegions[i].name() << nl << endl;

        IOdictionary transportProperties
        (
           IOobject
           (
                    "transportProperties",
                    runTime.constant(),
                    fluidRegions[i],
                    IOobject::MUST_READ,
                    IOobject::NO_WRITE
           )
        ); 

        Info<< "    Adding to UFluid\n" << endl;
        UFluid.set
        (
            i,
            new volVectorField
            (
                IOobject
                (
                    "U",
                    runTime.timeName(),
                    fluidRegions[i],
                    IOobject::MUST_READ,
                    IOobject::AUTO_WRITE
                ),
                fluidRegions[i]
            )
        );
       Info<< "    Adding to UfFluid\n" << endl;	
	UfFluid.set
        (
            i,
            new surfaceVectorField("Uf", fvc::interpolate(UFluid[i]))
        );
       Info<< "    Adding to pFluid\n" << endl;
        pFluid.set
        (
            i,
            new volScalarField
            (
                IOobject
                (
                    "p",
                    runTime.timeName(),
                    fluidRegions[i],
                    IOobject::MUST_READ,
                    IOobject::AUTO_WRITE
                ),
                fluidRegions[i]
            )
        );
        deltTFluid.set
        (
        	i,
        	new dimensionedScalar(runTime.deltaT())
        );

	// Kynematic viscosity
        nuFluid.set
        (
        	i,
        	new dimensionedScalar(transportProperties.lookup("nu"))
        );
	
	// density
        rhoFluid.set
        (
        	i,
        	new dimensionedScalar(transportProperties.lookup("rho"))
        );
          betaFluid.set
        (
        	i,
        	new dimensionedScalar(transportProperties.lookup("beta"))
        );

           T_0Fluid.set
        (
        	i,
        	new dimensionedScalar(transportProperties.lookup("T_0"))
        );

           gFluid.set
        (
        	i,
        	new dimensionedVector(transportProperties.lookup("g"))
        );
           PrtFluid.set
        (
        	i,
        	new dimensionedScalar(transportProperties.lookup("Prt"))
        );

           PrFluid.set
        (
        	i,
        	new dimensionedScalar(transportProperties.lookup("Pr"))
        );
	
        Info<< "    Adding to TFluid\n" << endl;
         TFluid.set
        (
            i,
            new volScalarField
            (
                IOobject
                (
                    "T",
                    runTime.timeName(),
                    fluidRegions[i],
                    IOobject::MUST_READ,
                    IOobject::AUTO_WRITE
                ),
                fluidRegions[i]
            )
        );

        Info<< "    Adding to phiFluid\n" << endl;
        phiFluid.set
        (
            i,
            new surfaceScalarField
            (
                IOobject
                (
                    "phi",
                    runTime.timeName(),
                    fluidRegions[i],
                    IOobject::READ_IF_PRESENT,
                    IOobject::AUTO_WRITE
                ),
            fvc::interpolate(UFluid[i]) & fluidRegions[i].Sf()
	   //-fvc::snGrad(pFluid[i])*(fluidRegions[i].Sf()/ fluidRegions[i].magSf())*deltTFluid
           //[i])&fluidRegions[i].Sf()
            )
        );

        Info<< "    Adding to phi_0Fluid\n" << endl;
        phi_0Fluid.set
        (
            i,
            new surfaceScalarField
            (
                IOobject
                (
                    "phi_0",
                    runTime.timeName(),
                    fluidRegions[i],
                    IOobject::READ_IF_PRESENT,
                    IOobject::AUTO_WRITE
                ),
		phiFluid[i]
	    )
        );
/*
          Info<< "    Adding to alphaFluid\n" << endl;
         alphaFluid.set
        (
            i,
            new volScalarField
            (
                IOobject
                (
                    "alpha",
                    runTime.timeName(),
                    fluidRegions[i],
                    IOobject::MUST_READ,
                    IOobject::AUTO_WRITE
                ),
                fluidRegions[i]
            )
        );
*/

	laminarTransportFluid.set//jiade
        (
            i,
	    new singlePhaseTransportModel(UFluid[i], phiFluid[i])
        );

        Info<< "    Adding to turbulence\n" << endl;//jiade
        turbulenceFluid.set
        (
            i,
            incompressible::turbulenceModel::New
            (
                UFluid[i],
                phiFluid[i],
                laminarTransportFluid[i]		
            ).ptr()
        );

          Info<< "    Adding to alphatFluid\n" << endl;//jiade
         alphatFluid.set//jiade
        (
            i,
            new volScalarField
            (
                IOobject
                (
                    "alphat",
                    runTime.timeName(),
                    fluidRegions[i],
                    IOobject::MUST_READ,
                    IOobject::AUTO_WRITE
                ),
                fluidRegions[i]
            )
        );
/*
	Info<< "    Adding to sigmaMagFluid\n" << endl;

        sigmaMagFluid.set
        (
            i,
            new volScalarField
            (
                IOobject
                (
                    "sigmaMag",
                    runTime.timeName(),
                    fluidRegions[i],
                    IOobject::MUST_READ,
                    IOobject::AUTO_WRITE
                ),
                fluidRegions[i]
            )
        );
*/
	Info<< "    Adding to sigmaFluid\n" << endl;	
        sigmaFluid.set
        (
            i,
            new volScalarField
            (
                IOobject
                (
                    "sigma",
                    runTime.timeName(),
                    fluidRegions[i],
                    IOobject::MUST_READ,
                    IOobject::AUTO_WRITE
                ),
                fluidRegions[i]
            )
        );

	Info<< "    Adding to ElPotFluid\n" << endl;
        ElPotFluid.set
        (
            i,
            new volScalarField
            (
                IOobject
                (
                    "ElPot",
                    runTime.timeName(),
                    fluidRegions[i],
                    IOobject::MUST_READ,
                    IOobject::AUTO_WRITE
                ),
                fluidRegions[i]
            )
        );

        Info<< "    Adding to BFluid\n" << endl;
        BFluid.set
        (
            i,
            new volVectorField
            (
                IOobject
                (
                    "B",
                    runTime.timeName(),
                    fluidRegions[i],
                    IOobject::MUST_READ,
                    IOobject::AUTO_WRITE
                ),
		fluidRegions[i]	
            )
        );

	BfFluid.set
        (
            i,
            new surfaceVectorField("Bf", fvc::interpolate(BFluid[i]))
        );
	
	Info<< "    Adding to JsfFluid\n" << endl;
        JsfFluid.set
        (
            i,
            new surfaceScalarField
            (
                IOobject
                (
                    "Jsf",
                    runTime.timeName(),
                    fluidRegions[i],
                    IOobject::NO_READ,
                    IOobject::NO_WRITE
                ),
                //fluidRegions[i]
                - fvc::interpolate(sigmaFluid[i]) * fvc::snGrad(ElPotFluid[i])
            )
        );
	
	Info<< "    Adding to JubsfFluid\n" << endl;
        JubsfFluid.set
        (
            i,
            new surfaceScalarField
            (
                IOobject
                (
                    "Jubsf",
                    runTime.timeName(),
                    fluidRegions[i],
                    IOobject::NO_READ,
                    IOobject::NO_WRITE
                ),
                //fluidRegions[i]
                (fvc::interpolate(sigmaFluid[i]) * (UfFluid[i] ^ BfFluid[i]))
	& fluidRegions[i].Sf() / fluidRegions[i].magSf()
            )
        );
	
	Info<< "    Adding to JubefFluid\n" << endl;
        JubefFluid.set
        (
            i,
            new surfaceVectorField
            (
                IOobject
                (
                    "Jubef",
                    runTime.timeName(),
                    fluidRegions[i],
                    IOobject::NO_READ,
                    IOobject::NO_WRITE
                ),
                //fluidRegions[i]
                UfFluid[i] ^ BfFluid[i]
            )
        );
	
	Info<< "    Adding to JstfFluid\n" << endl;
        JstfFluid.set
        (
            i,
            new surfaceScalarField
            (
                IOobject
                (
                    "Jstf",
                    runTime.timeName(),
                    fluidRegions[i],
                    IOobject::NO_READ,
                    IOobject::NO_WRITE
                ),
                //fluidRegions[i]
	     JubsfFluid[i] + JsfFluid[i]
            )
        );
	
	Info<< "    Adding to JetfFluid\n" << endl;
        JetfFluid.set
        (
            i,
            new surfaceVectorField
            (
                IOobject
                (
                    "Jetf",
                    runTime.timeName(),
                    fluidRegions[i],
                    IOobject::NO_READ,
                    IOobject::NO_WRITE
                ),
                //fluidRegions[i]
                JstfFluid[i] * fluidRegions[i].Sf() / fluidRegions[i].magSf()
            )
        );
	
	Info<< "    Adding to JecFluid\n" << endl;
        JecFluid.set
        (
            i,
            new volVectorField
            (
                IOobject
                (
                    "Jec",
                    runTime.timeName(),
                    fluidRegions[i],
                    IOobject::NO_READ,
                    IOobject::AUTO_WRITE
                ),
                //fluidRegions[i]
	     fvc::surfaceSum(JetfFluid[i] /2)
            )
        );
	
	Info<< "    Adding to LforceFluid\n" << endl;
        LforceFluid.set
        (
            i,
            new volVectorField
            (
                IOobject
                (
                    "Lforce",
                    runTime.timeName(),
                    fluidRegions[i],
                    IOobject::NO_READ,
                    IOobject::AUTO_WRITE
                ),
                //fluidRegions[i]
                (JecFluid[i] ^ BFluid[i]) / rhoFluid[i]
	     //JecFluid[i] ^ BFluid[i]
            )
        );

        
        const dictionary& pimpleDict =
            fluidRegions[i].solutionDict().subDict("PIMPLE");
	    
         setRefCell
        (
            pFluid[i],
	   // ElPotFluid[i],
            pimpleDict,
            pRefCellFluid[i],
            pRefValueFluid[i]
	    //ElPotRefCellFluid[i],
          //  ElPotRefValueFluid[i]
        );

    }
